package gov.va.genisis2;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class QueryModelEditor extends JFrame {

	private static final long serialVersionUID = 1L;

	protected QueryModel model;

	protected JLabel endPointLabel;
	protected JTextField endPointPanel;
	protected JLabel endPointStatus;

	protected JLabel queryLabel;
	protected JTextArea queryTextArea;

//	protected JLabel resultsLabel;
	protected JTextArea resultsArea;
	
//	protected JLabel curlEndpointLabel;
	protected JTextArea curlEndointTextArea;

	protected JButton sendQuery;

	public QueryModelEditor(String title, QueryModel m) {
		super(title);

		model = m;
		createComponents();
		layoutComponents();
	}

	public void createComponents() {
		endPointLabel = new JLabel("Endpoint URL");
		endPointPanel = new JTextField(model.getEndpointURL(), 20);
		endPointStatus = new JLabel();

		queryLabel = new JLabel("Query");
		queryTextArea = new JTextArea(10, 50);
		queryTextArea.setText(model.getQuery());
		queryTextArea.setBorder(new EtchedBorder());

//		resultsLabel = new JLabel("Results");
		resultsArea = new JTextArea(24, 12);
		resultsArea.setBorder(new TitledBorder(new EtchedBorder(), "Results"));
		resultsArea.setEditable(false);
		
//		curlEndpointLabel = new JLabel("Curl Endpoint Format");
		curlEndointTextArea = new JTextArea(10, 20);
		curlEndointTextArea.setText(model.getCurlEndpointURL());
		curlEndointTextArea.setBorder(new TitledBorder(new EtchedBorder(), "Curl Endpoint Format"));
		curlEndointTextArea.setEditable(false);

		sendQuery = new JButton("Send Query");
		sendQuery.addActionListener(new ActionListener() {

			@Override
			public void actionPerformed(ActionEvent e) {
//				String results = "";
				// capture data from endpoint field and query text area
				model.setEndpointURL(endPointPanel.getText());
				model.setQuery(queryTextArea.getText());

				JenaConnection jc = new JenaConnection(model.getEndpointURL());
//				// test connection
//				results += jc.testConnection()+"\n";
//				resultsArea.setText(results);
//
//				// execute query
//				results += jc.executeQuery(model.getQuery());
//				resultsArea.setText(results);
//				String testResults = jc.testConnection();
//				endPointStatus.setText( testResults );
				
				new Thread(new Runnable() {
				    public void run() {
				    	final String testResults = jc.testConnection();
				    	try {
							Thread.sleep(jc.connectionTimeout);
						} catch (InterruptedException e) {
						}
				    	SwingUtilities.invokeLater(new Runnable() {
							@Override
							public void run() {
								endPointStatus.setText( testResults );
							}
						});
				    }
				}).start();
				
				new Thread(new Runnable() {
				    public void run() {
				    	final String connectionResults = jc.executeQuery(model.getQuery());
				    	try {
							Thread.sleep(jc.connectionTimeout);
						} catch (InterruptedException e) {
						}
				    	SwingUtilities.invokeLater(new Runnable() {
							@Override
							public void run() {
								resultsArea.setText( connectionResults );
							}
						});
				    }
				}).start();
				
				new Thread(new Runnable() {
				    public void run() {
//				    	final String connectionResults = jc.executeQuery(model.getQuery());
				    	try {
							Thread.sleep(jc.connectionTimeout);
						} catch (InterruptedException e) {
						}
				    	SwingUtilities.invokeLater(new Runnable() {
							@Override
							public void run() {
								curlEndointTextArea.setText( jc.getCurlFormat()+"" );
							}
						});
				    }
				}).start();
			}
		});

	}

	public void layoutComponents() {

		setLayout(new BoxLayout(getContentPane(), BoxLayout.Y_AXIS));

		JPanel firstRow = new JPanel(new FlowLayout(FlowLayout.LEFT));
		firstRow.add(endPointLabel);
		firstRow.add(endPointPanel);
		firstRow.add( endPointStatus);

		add(firstRow);

		JPanel secondRow = new JPanel(new FlowLayout(FlowLayout.LEFT));
		secondRow.add(queryLabel);
		secondRow.add(new JScrollPane(queryTextArea));

		add(secondRow);

		JPanel thirdRow = new JPanel(new FlowLayout(FlowLayout.RIGHT));
		thirdRow.add(sendQuery);

		add(thirdRow);

		add(new JScrollPane(resultsArea));
		
		add(new JScrollPane(curlEndointTextArea));

	}

}
